package com.perforce.hws.server;

import java.nio.charset.Charset;
import java.util.Base64;

import spark.Request;

/**
 * Helper methods to work with a Sparck request.
 */
public abstract class RequestHelper {
	
	/**
	 * Gets the credentials from the request 'Authorization'
	 * header expecting this to be Basic Auth with the 
	 * authorization Base64 encoding with user:password.
	 * @param request the request
	 * @return the credentials as a String[] with user name in
	 * position 0 and the password in position 1.
	 */
	public static String[] getCredentials(final Request request) {
    	String[] credentials = null;
    	
    	final String authorization = request.headers("Authorization");
        if (authorization != null && authorization.startsWith("Basic")) {
            // credentials = username:password
            credentials = getCredentials(
            		authorization.substring("Basic".length()).trim());
        }
    	return credentials;
    }
	
	/**
	 * Gets the credentials from a credentials String expecting
	 * Base64 encoding with user:password.
	 *
	 * @param authorization the authorization
	 * @return the credentials as a String[] with user name in
	 * position 0 and the password in position 1.
	 */
	public static String[] getCredentials(final String authorization) {
    	String[] credentials = null;
        if (authorization != null) {
            String credentialsString =
            		new String(Base64.getDecoder().decode(authorization),
                    Charset.forName("UTF-8"));
            // credentials = username:password
            credentials = credentialsString.split(":", 2);
        }
    	return credentials;
    }
}
