package com.perforce.hws.server;

import com.sun.jna.*;

/**
 * Uses JNA to make platform calls to let our server change the user account.
 */
public class SetUIDMethods {

    interface CLibrary extends Library {
        CLibrary INSTANCE = (CLibrary) Native.loadLibrary((Platform.isWindows() ? "msvcrt" : "c"), CLibrary.class);

        int umask(int umask);

        int setuid(int uid);

        int setgid(int gid);

        int getuid();
    }

    public static int setumask(int umask) {
        if (Platform.isWindows())
            return 0;
        return CLibrary.INSTANCE.umask(umask);
    }

    public static int setuid(int uid) {
        if (Platform.isWindows())
            return 0;
        return CLibrary.INSTANCE.setuid(uid);
    }

    public static int setgid(int gid) {
        if (Platform.isWindows())
            return 0;
        return CLibrary.INSTANCE.setgid(gid);
    }

    public static int getuid() {
        if (Platform.isWindows())
            return -1;
        return CLibrary.INSTANCE.getuid();
    }
}
