package com.perforce.hws.server;

/**
 * Used to flag a particular server ID is not available or not configured.
 */
public class UnknownServerException extends RuntimeException {

    private String serverId;

    public UnknownServerException(String serverId) {
        this.serverId = serverId;
    }

    public UnknownServerException(Throwable cause, String serverId) {
        super(cause);
        this.serverId = serverId;
    }

    public UnknownServerException(String message, String serverId) {
        super(message);
        this.serverId = serverId;
    }

    public UnknownServerException(String message, Throwable cause, String serverId) {
        super(message, cause);
        this.serverId = serverId;
    }

    public UnknownServerException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, String serverId) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.serverId = serverId;
    }

    public String getServerId() {
        return serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }
}
