package com.perforce.hws.server;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.json.JsonHttpContent;
import spark.Request;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;

/**
 * Created by tjuricek on 1/27/16.
 */
public interface WebHookMethods extends UrlBuilderMethods {

    default <T> T execWebHook(Supplier<HttpRequestFactory> requestFactory,
                              Request request,
                              HWSSettings settings,
                              String method,
                              String urlTemplate,
                              Object pathParams,
                              Map<String, String> uriParams,
                              Object content,
                              Class<T> returnType)
            throws IOException {

        GenericUrl genericUrl = buildUrl(urlTemplate, pathParams, uriParams);

        JsonHttpContent jsonHttpContent = null;
        if (content != null) {
            jsonHttpContent = new JsonHttpContent(getJsonFactory(), content);
        }

        HttpRequest hookRequest =
                requestFactory.get().buildRequest(method, genericUrl, jsonHttpContent);

        hookRequest.getHeaders().setBasicAuthentication(
                request.attribute("user"), request.attribute("ticket"));

        HttpResponse hookResponse = hookRequest.execute();
        return hookResponse.parseAs(returnType);
    }
}
