package com.perforce.hws.server.filters;

import jdk.nashorn.api.scripting.NashornScriptEngine;
import spark.Filter;
import spark.Request;
import spark.Response;

import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

import com.perforce.hws.server.HWSSettings;

import java.io.FileReader;
import java.io.IOException;

import static spark.Spark.halt;

/**
 * Created by tjuricek on 1/25/16.
 */
public class CustomRequestFilter implements Filter {

    private HWSSettings settings;

    private NashornScriptEngine engine;

    public CustomRequestFilter(HWSSettings settings) throws IOException, ScriptException {
        this.settings = settings;

        this.engine =
                (NashornScriptEngine) new ScriptEngineManager().getEngineByName("nashorn");

        this.engine.eval(new FileReader(settings.getRequestFilterPath()));
    }

    @Override
    public void handle(Request request, Response response) throws Exception {
        Boolean requestOk = (Boolean)this.engine.invokeFunction("validateRequest", request);
        if (!requestOk) {
            halt(400);
        }
    }
}
