package com.perforce.hws.server.filters;

import com.perforce.hws.server.HWSSettings;

import spark.Filter;
import spark.Request;
import spark.Response;

/**
 * JavaScript clients will need these settings configured
 */
public class EnableCORSFilter implements Filter {

    private HWSSettings settings;

    public EnableCORSFilter(HWSSettings settings) {
        this.settings = settings;
    }

    @Override
    public void handle(Request request, Response response) throws Exception {
        response.header("Access-Control-Allow-Origin", settings.getAccessControlAllowOrigin());
        response.header("Access-Control-Request-Method", settings.getAccessControlRequestMethod());
        response.header("Access-Control-Allow-Headers", settings.getAccessControlAllowHeaders());
    }
}
