package com.perforce.hws.server.filters;

import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import spark.Filter;
import spark.Request;
import spark.Response;

import java.util.function.Supplier;

/**
 * Provides the "requestFactory" handle to the request.
 * <p>
 * This will actually be a Supplier for an HttpRequestFactory. (We don't
 * generate and wire together everything unless you really need it.)
 */
public class HttpRequestFactoryFilter implements Filter {

    HttpTransport httpTransport;

    JsonFactory jsonFactory;

    HttpRequestFactory requestFactory;

    public HttpRequestFactoryFilter() {
        requestFactory = null;
        httpTransport = null;
        jsonFactory = null;
    }

    @Override
    public void handle(Request request, Response response) throws Exception {
        Supplier<HttpRequestFactory> supplier = () -> getRequestFactory();
        request.attribute("requestFactory", supplier);
    }

    public HttpRequestFactory getRequestFactory() {
        if (requestFactory == null) {
            initRequestFactory();
        }
        return requestFactory;
    }

    private void initRequestFactory() {
        httpTransport = new NetHttpTransport();
        jsonFactory = new JacksonFactory();
        requestFactory = httpTransport.createRequestFactory(r -> {
            r.setParser(new JsonObjectParser(jsonFactory));
        });
    }
}
