package com.perforce.hws.server.filters;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import spark.Filter;
import spark.Request;
import spark.Response;

/**
 * Set our response content type to application/json. We will *always* return
 * this content type for now.
 *
 * Check the HelixWebServices, but almost all routes should just convert all
 * output to JSON via Gson.
 */
public class JsonContentTypeFilter implements Filter {

	/** The specific logger for this processing. */
    private Logger logger = LoggerFactory.getLogger(JsonContentTypeFilter.class);

    @Override
    public void handle(final Request request, final Response response)
    		throws Exception {
    	logger.debug("Setting content type for " + request);
    	// This was intended to cope with doc requests in other formats
    	// however they are filtered out a long time before here.
        if (request.pathInfo().startsWith("/api/doc")) {
            if (request.pathInfo().endsWith(".yaml")) {
                response.header("Content-Type", "text/yaml");
            } else if (request.pathInfo().endsWith(".json")) {
                response.header("Content-Type", "application/json");
            } else if (request.pathInfo().endsWith(".html")) {
                response.header("Content-Type", "text/html");
            }
            return;
        }
        if (request.attribute("response_content_type_set") == null) {
            response.header("Content-Type", "application/json");
        }
    }
}
