package com.perforce.hws.server.filters;

import com.perforce.hws.server.HWSSettings;

import spark.Filter;
import spark.Request;
import spark.Response;

/**
 * This will inject a copy of application settings into the request to the
 * <code>settings</code> attribute.
 * <p>
 * This is generally what you want to put early in your filter stack, since
 * other filters will probably want to grab configuration.
 * <p>
 * We read overrides of certain settings from the request. See HWSSettings for
 * more details.
 */
public class SettingsFilter implements Filter {

    public SettingsFilter(HWSSettings settings) {
        this.settings = settings;
    }

    @Override
    public void handle(Request request, Response response) throws Exception {
        HWSSettings copy = (HWSSettings) settings.clone();
        copy.override(request);
        request.attribute("settings", copy);
    }

    private HWSSettings settings;
}
