package com.perforce.hws.server.filters;

import spark.Filter;
import spark.Request;
import spark.Response;

import static com.perforce.hws.server.VersionHelpers.productVersion;

import java.io.IOException;

/**
 * Provides our application version in a response header.
 */
public class VersionFilter implements Filter {

    private String version;

    public VersionFilter() throws IOException {
        version = productVersion();
    }

    @Override
    public void handle(Request request, Response response) throws Exception {
        request.attribute("version", version);
        response.header("X-Helix-Web-Services-Version", version);
    }
}
