package com.perforce.hws.server.routes;

import spark.Request;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Created by tjuricek on 1/20/16.
 */
public interface HasArgList {

    default List<String> argList(Request request) {
        List<String> args = new ArrayList<>();

        if (request.queryString() != null) {
            Arrays.stream(request.queryString().split("&"))
                    .map(pair -> pair.split("="))
                    .filter(kv -> kv[0].startsWith("arg"))
                    .map(kv -> {
                        try {
                            kv[1] = URLDecoder.decode(kv[1], "utf8");
                        } catch (UnsupportedEncodingException e) {
                            throw new IllegalStateException(e);
                        }
                        return kv;
                    })
                    .forEach(kv -> args.add(kv[1]));
        }

        return args;
    }
}
