package com.perforce.hws.server.routes;

import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.RequestHelper;
import com.perforce.hws.server.Login;
import com.perforce.hwsclient.models.LoginRequest;
import com.perforce.hwsclient.models.LoginResponse;

import spark.Request;
import spark.Response;
import spark.Route;

import static spark.Spark.halt;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;

/**
 * Handles login for hws/<version>/login and 
 * p4d/<version>/<server>/login.
 */
public class LoginRoute implements Route, 
								   ProvidesLoginRoute,
								   Login {
    /* (non-Javadoc)
     * @see spark.Route#handle(spark.Request, spark.Response)
     */
    @Override
    public Object handle(final Request request, final Response response)
    		throws Exception {
        HWSSettings settings = request.attribute("settings");
        String p4AuthServerId = request.params("server");
        // If there is not a server id in the request we expect
        // the default to have been configured in Hws settings.
        if (StringUtils.isEmpty(p4AuthServerId)) {
        	p4AuthServerId = settings.getAuthP4d();
        	if (StringUtils.isEmpty(p4AuthServerId)) {
        		halt(HttpStatus.SC_FORBIDDEN, "Unspecified login server");
        	}
        }
        // We expect basic auth
        String[] credentials = RequestHelper.getCredentials(request);
        if (credentials == null || credentials.length < 2
        		|| credentials[0] == null
        		|| credentials[1] == null) {
            halt(HttpStatus.SC_FORBIDDEN, "Unauthorized");
        }
        LoginRequest loginRequest = new LoginRequest();
        loginRequest.setUser(credentials[0]);
        loginRequest.setPassword(credentials[1]);
        LoginResponse loginResponse =
    		login(loginRequest, settings, p4AuthServerId);
        return handleLoginResponse(loginResponse, request, response);
    }
}
