package com.perforce.hws.server.routes;

import com.perforce.hws.p4base.AuthMethods;
import com.perforce.hws.p4base.HasGson;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hwsclient.models.LoginRequest;
import com.perforce.hwsclient.models.LoginResponse;
import com.perforce.p4java.exception.AccessException;
import spark.Request;
import spark.Response;

import java.util.HashMap;
import java.util.Map;

import static spark.Spark.halt;

/**
 *
 */
public interface ProvidesLoginRoute extends AuthMethods, HasGson, ModelConversion {

    default Object handleLoginResponse(LoginResponse loginResponse, Request request, Response response) {
        String acceptHeader = request.headers("Accept");
        if (acceptHeader != null && acceptHeader.contains("text/plain")) {
            request.attribute("response_content_type_set", "true");
            response.header("Content-Type", "text/plain");
            response.header("Content-Length", Integer.toString(loginResponse.getTicket().getBytes().length));
            return loginResponse.getTicket();
        } else {
            return gson.toJson(loginResponse);
        }
    }
}
