package com.perforce.hws.server.routes;

import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.StatusChecks;
import com.perforce.hwsclient.models.HWSStatus;
import spark.Request;
import spark.Response;
import spark.Route;

/**
 * Provides a very simple check for monitoring systems.
 * <p>
 * This also allows apps to grab the version response header without having
 * to log in.
 */
public class StatusRoute implements Route, StatusChecks {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        HWSSettings settings = request.attribute("settings");

        HWSStatus status = new HWSStatus();
        status.setStatus(isStatusOk(settings) ? "OK" : "ERROR");
        status.setVersion(request.attribute("version"));

        return status;
    }
}
