package com.perforce.hws.server.routes;

import java.util.Map;

public interface UserRoute {

    /**
     * P4d does not return "nothing" if the user doesn't exist... it returns
     * an email address with the string "user@INVALID".
     *
     * @param user
     * @return
     */
    default boolean isInvalidUserEmail(Map<String, Object> user) {
        return user.containsKey("Email") &&
                ((String)user.get("Email")).endsWith("@INVALID");
    }
}
