package com.perforce.hws.server.routes;

import java.util.List;

import com.perforce.hws.server.HWSSettings;

/**
 * Created by tjuricek on 1/20/16.
 */
public interface UsesCommandWhitelist {

    default boolean isWhitelisted(HWSSettings settings, String command, List<String> args) {
        List<HWSSettings.WhitelistedCommand> whitelist = settings.getCommandWhitelist();
        if (whitelist == null || whitelist.isEmpty()) {
            return true;
        }

        return whitelist.stream()
                .anyMatch(cmd ->
                        cmd.getCommand().equals(command) &&
                        (cmd.getRequiredArgs() == null ||
                                cmd.getRequiredArgs().isEmpty() ||
                                args.containsAll(cmd.getRequiredArgs())));
    }
}
