package com.perforce.hws.server.routes.git_fusion;

import com.perforce.hws.gf.GitFusionConfigMethods;
import com.perforce.hws.p4base.HasGson;
import com.perforce.hws.p4base.ResultMap;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.GitFusionRepoConfig;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;

/**
 * POST /git-fusion-repos.
 */
public class GitFusionCreateRepoConfigRoute implements
        GitFusionConfigMethods,
        HasGson,
        ModelConversion,
        UsesJsonRequests,
        UsesServerHandles,
        Route {

    /* (non-Javadoc)
     * @see spark.Route#handle(spark.Request, spark.Response)
     */
    @Override
    public Object handle(final Request request, final Response response)
    		throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            GitFusionRepoConfig repoConfig =
            		readModel(request, GitFusionRepoConfig.class);

            String changelistDescription = String.format(
                    settings.getGitFusionCreateConfigDescriptionFormat(),
                    repoConfig.getName());

            List<ResultMap> resultMaps = replaceGitFusionRepoConfig(serverHandle,
                        settings.getGitFusionDepot(),
                        encodeGF(repoConfig.getName()),
                        repoConfig,
                        changelistDescription);

            return toCommandResponse(resultMaps);
        });
    }
}
