package com.perforce.hws.server.routes.git_fusion;

import com.perforce.hws.gf.GitFusionConfigMethods;
import com.perforce.hws.p4base.ResultMap;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;

/**
 * DELETE /git-fusion-repos
 */
public class GitFusionDeleteRepoConfigRoute implements
        GitFusionConfigMethods,
        ModelConversion,
        UsesServerHandles,
        Route {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        String repoId = request.params("repo");

        // TODO: Put this into config? Allow request override?
        String description =
                String.format("Removed repo config for %s", repoId);

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> resultMaps = deleteGitFusionRepoConfig(
                    serverHandle,
                    settings.getGitFusionDepot(),
                    repoId,
                    description);

            return toCommandResponse(resultMaps);
        });
    }
}
