package com.perforce.hws.server.routes.git_fusion;

import com.perforce.hws.gf.GitFusionConfigMethods;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

import java.io.IOException;
import java.io.UncheckedIOException;

/**
 * GET /git-fusion/v1/repos/*
 */
public class GitFusionGetRepoConfigRoute implements
        GitFusionConfigMethods,
        Route,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        String repoId = request.params("repo");

        return withServerHandle(server, sessionData, settings, serverHandle ->
            loadGitFusionRepoConfig(serverHandle, settings.getGitFusionDepot(), repoId)
        );
    }
}
