package com.perforce.hws.server.routes.git_fusion;

import com.perforce.hws.gf.GitFusionConfigMethods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

/**
 * GET /git-fusion-repos
 */
public class GitFusionListRepoConfigsRoute implements
        GitFusionConfigMethods,
        Route,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        return withServerHandle(server, sessionData, settings,
                serverHandle -> listGitFusionRepos(serverHandle, settings.getGitFusionDepot()));
    }
}
