package com.perforce.hws.server.routes.git_fusion;

import com.perforce.hws.gf.GitFusionConfigMethods;
import com.perforce.hws.p4base.HasGson;
import com.perforce.hws.p4base.ResultMap;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.GitFusionRepoConfig;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.Map;

/**
 * PATCH /git-fusion/v1/repos/*
 */
public class GitFusionUpdateRepoConfigRoute implements
        GitFusionConfigMethods,
        HasGson,
        ModelConversion,
        Route,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String repoId = request.params("repo");

        // TODO: Put this into config? Allow request override?
        String description =
                String.format("Patching repo config for %s", repoId);

        GitFusionRepoConfig updates = readModel(request, GitFusionRepoConfig.class);

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> resultMaps = patchGitFusionRepoConfig(serverHandle,
                    settings.getGitFusionDepot(),
                    repoId,
                    updates,
                    description);

            return toCommandResponse(resultMaps);
        });
    }
}

