package com.perforce.hws.server.routes.perforce;

import java.util.List;
import java.util.function.Supplier;

import com.perforce.hwsclient.models.GroupCommand;

/**
 * Provides methods to generate the group specification as a string instead of as a map.
 *
 * Currently (as of p4java 2015.2) the Ldap fields are not provided via the Map interface.
 */
public interface GroupSpecMethods {

    default String toGroupSpec(GroupCommand savedGroup) {
        // Another case where the p4java map interface does not work.
        // We have to build the "spec string" manually.
        StringBuilder sb = new StringBuilder();
        appendToSpecStrIfSet(sb, "Group", savedGroup::getGroup);
        appendToSpecStrIfSet(sb, "MaxResults", savedGroup::getMaxResults);
        appendToSpecStrIfSet(sb, "MaxScanRows", savedGroup::getMaxScanRows);
        appendToSpecStrIfSet(sb, "MaxLockTime", savedGroup::getMaxLockTime);
        appendToSpecStrIfSet(sb, "MaxOpenFiles", savedGroup::getMaxOpenFiles);
        appendToSpecStrIfSet(sb, "Timeout", savedGroup::getTimeout);
        appendToSpecStrIfSet(sb, "PasswordTimeout", savedGroup::getPasswordTimeout);
        appendToSpecStrIfSet(sb, "LdapConfig", savedGroup::getLdapConfig);
        appendToSpecStrIfSet(sb, "LdapSearchQuery", savedGroup::getLdapSearchQuery);
        appendToSpecStrIfSet(sb, "LdapUserAttribute", savedGroup::getLdapUserAttribute);
        appentToSpecStrIfSet(sb, "Subgroups", savedGroup::getSubgroups);
        appentToSpecStrIfSet(sb, "Owners", savedGroup::getOwners);
        appentToSpecStrIfSet(sb, "Users", savedGroup::getUsers);

        return sb.toString();
    }

    default void appendToSpecStrIfSet(StringBuilder sb, String key, Supplier<String> supplier) {
        String value = supplier.get();
        if (value != null) {
            sb.append(key)
                    .append(": ")
                    .append(value)
                    .append("\n");
        }
    }

    default void appentToSpecStrIfSet(StringBuilder sb, String key, Supplier<List<String>> supplier) {
        List<String> array = supplier.get();
        if (array != null) {
            sb.append(key).append(": \n");
            array.forEach(s -> {
                sb.append("\t").append(s).append("\n");
            });
            sb.append("\n");
        }
    }
}
