package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.BranchCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.Map;

/**
 * POST /p4/:api/branches
 */
public class PerforceCreateBranchRoute implements
        Route,
        P4Methods,
        HasGson,
        ResultMapMethods,
        ModelConversion,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        BranchCommand branch = readModel(request, BranchCommand.class);

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> results = execInput(serverHandle,
                    toRequestMap(branch),
                    "branch", "-i");

            return toCommandResponse(results);
        });
    }
}
