package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.CreateChange;
import com.perforce.hws.p4base.HasGson;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.ChangelistRequest;

import spark.Request;
import spark.Response;
import spark.Route;

/**
 * POST /p4/:api/changes
 */
public class PerforceCreateChangeRoute implements
        Route,
        HasGson,
        ModelConversion,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        ChangelistRequest changeRequest = readModel(request, ChangelistRequest.class);

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            CreateChange createChange = new CreateChange(serverHandle);

            return toCommandResponse(createChange.apply(changeRequest));
        });
    }
}
