package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.HasGson;
import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ResultMapMethods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.ClientCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.Map;

/**
 * POST /p4/:api/clients
 */
public class PerforceCreateClientRoute implements
        Route,
        P4Methods,
        HasGson,
        ResultMapMethods,
        ModelConversion,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        ClientCommand clientCommand = readModel(request, ClientCommand.class);

        Map<String, Object> inputMap = toRequestMap(clientCommand);

        return withServerHandle(server, sessionData, settings,
                serverHandle -> toCommandResponse(execInput(serverHandle, inputMap, "client", "-i")));
    }
}
