package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.GroupCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import javax.xml.transform.Result;
import java.util.List;
import java.util.Map;

import static spark.Spark.halt;

/**
 * POST /p4/:api/groups
 */
public class PerforceCreateGroupRoute implements
        Route,
        P4Methods,
        HasGson,
        ResultMapMethods,
        GroupSpecMethods,
        ModelConversion,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        GroupCommand groupCommand = readModel(request, GroupCommand.class);

        String groupSpec = toGroupSpec(groupCommand);

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> resultMaps =
                    execInputString(serverHandle, groupSpec, "group", "-i");

            // For group queries, the server decides to return a warning (which is
            // different from all other specs) if group creation is unsuccessful.

            if (resultMaps.stream().anyMatch(m ->
                    m.getErrors().stream().anyMatch(ErrorIds.MsgDm_GroupNotCreated::equals))) {
                halt(400, gson.toJson(resultMaps));
            }

            return toCommandResponse(resultMaps);
        });
    }
}
