package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.HasGson;
import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ResultMapMethods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.JobCommand;

import com.perforce.p4java.impl.generic.core.Job;
import spark.Request;
import spark.Response;
import spark.Route;

import java.util.Map;

/**
 * POST /p4/:api/jobs
 */
public class PerforceCreateJobRoute implements
        Route,
        P4Methods,
        HasGson,
        ResultMapMethods,
        ModelConversion,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        JobCommand jobCommand = readModel(request, JobCommand.class);

        Map<String, Object> requestMap = toRequestMap(jobCommand);

        return withServerHandle(server, sessionData, settings,
                serverHandle -> toCommandResponse(execInput(serverHandle, requestMap, "job", "-i")));
    }
}
