package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.LabelCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.Map;

import static java.util.stream.Collectors.toList;

/**
 * POST /p4/:api/labels
 */
public class PerforceCreateLabelRoute implements
        Route,
        P4Methods,
        HasGson,
        ModelConversion,
        ResultMapMethods,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        LabelCommand labelCommand = readModel(request, LabelCommand.class);

        Map<String, Object> requestMap = toRequestMap(labelCommand);

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> resultMaps =
                    execInput(serverHandle, requestMap, "label", "-i");

            return toCommandResponse(resultMaps);
        });
    }
}
