package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.ServerCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.Map;

/**
 * POST /p4/:api/servers
 */
public class PerforceCreateServerRoute implements
        Route,
        P4Methods,
        HasGson,
        ServerSpecMethods,
        ModelConversion,
        ResultMapMethods,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        ServerCommand serverCommand = readModel(request, ServerCommand.class);

        Map<String, Object> serverSpec = toRequestMap(serverCommand);

        return withServerHandle(server, sessionData, settings,
                serverHandle -> toCommandResponse(saveServerSpec(serverHandle, serverSpec)));
    }
}
