package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.StreamCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.Map;

import static java.util.stream.Collectors.toList;

/**
 * POST /p4/:api/streams
 */
public class PerforceCreateStreamRoute implements
        Route,
        ModelConversion,
        P4Methods,
        HasGson,
        ResultMapMethods,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        StreamCommand streamCommand = readModel(request, StreamCommand.class);

        Map<String, Object> requestMap = toRequestMap(streamCommand);

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> resultMaps =
                    execInput(serverHandle, requestMap, "stream", "-i");

            return toCommandResponse(resultMaps);
        });
    }
}