package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.HasGson;
import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ResultMapMethods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.UserCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.Map;

/**
 * POST /p4/:api/users
 */
public class PerforceCreateUserRoute implements
        Route,
        P4Methods,
        ModelConversion,
        HasGson,
        ResultMapMethods,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        UserCommand userCommand = readModel(request, UserCommand.class);

        Map<String, Object> requestMap = toRequestMap(userCommand);

        return withServerHandle(server, sessionData, settings,
                serverHandle -> toCommandResponse(execInput(serverHandle, requestMap, "user", "-f", "-i")));
    }
}

