package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

/**
 * DELETE /p4/:api/groups/:group
 */
public class PerforceDeleteGroupRoute implements
        Route,
        P4Methods,
        ModelConversion,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String group = request.params("group");

        return withServerHandle(server, sessionData, settings,
                serverHandle -> toCommandResponse(exec(serverHandle, "group", "-d", group)));
    }
}
