package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

/**
 * DELETE /p4/:api/labels/:label
 */
public class PerforceDeleteLabelRoute implements
        Route,
        ModelConversion,
        P4Methods,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String label = request.params("label");

        return withServerHandle(server, sessionData, settings,
                serverHandle -> toCommandResponse(exec(serverHandle, "label", "-d", label)));
    }
}
