package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.StreamRoute;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

/**
 * DELETE /p4/:api/streams/:stream
 */
public class PerforceDeleteStreamRoute implements
        Route,
        P4Methods,
        ModelConversion,
        StreamRoute,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String stream = getStream(request);

        return withServerHandle(server, sessionData, settings,
                serverHandle -> toCommandResponse(exec(serverHandle, "stream", "-d", stream)));
    }
}

