package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ResultMap;
import com.perforce.hws.p4base.ResultMapMethods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.HasArgList;
import com.perforce.hws.server.routes.UsesCommandWhitelist;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;

import static java.util.stream.Collectors.toList;
import static spark.Spark.halt;

/**
 * GET /p4/:api/commands/:command
 */
public class PerforceExecCommandRoute implements
        Route,
        HasArgList,
        UsesCommandWhitelist,
        P4Methods,
        ResultMapMethods,
        ModelConversion,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String command = request.params("command");

        List<String> argList = argList(request);

        if (!isWhitelisted(settings, command, argList)) {
            halt(400);
        }

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> resultMaps =
                    exec(serverHandle, command, argList.toArray(new String[0]));

            return toCommandResponse(resultMaps);
        });
    }
}
