package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.HasArgList;
import com.perforce.hws.server.routes.UsesCommandWhitelist;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.Map;

import static java.util.stream.Collectors.toList;
import static spark.Spark.halt;

/**
 * POST /p4/:api/commands/:command
 */
public class PerforceExecInputCommandRoute implements
        Route,
        HasArgList,
        HasGson,
        UsesCommandWhitelist,
        P4Methods,
        ResultMapMethods,
        ModelConversion,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String command = request.params("command");

        List<String> argList = argList(request);

        String json = request.body();

        Map<String, Object> data =
                gson.fromJson(json, objectMapType);

        Map<String, Object> inputMap = divideArrayEntries(data);

        if (!isWhitelisted(settings, command, argList)) {
            halt(400);
        }

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> resultMaps =
                    execInput(serverHandle, inputMap, command, argList.toArray(new String[0]));

            return toCommandResponse(resultMaps);
        });
    }
}
