package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ResultMap;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;

/**
 * POST /jobs/{job}/fixes/{change}
 */
public class PerforceFixJobRoute implements
        Route,
        P4Methods,
        ModelConversion,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        String job = request.params("job");
        String change = request.params("change");
        String status = request.queryParams("status");

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> resultMaps = null;

            if (status != null) {
                resultMaps = exec(serverHandle, "fix", "-c", change, "-s", status, job);
            } else {
                resultMaps = exec(serverHandle, "fix", "-c", change, job);
            }

            return toCommandResponse(resultMaps);
        });
    }
}
