package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ResultMap;
import com.perforce.hws.p4base.ResultMapMethods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;

/**
 * GET /p4/:api/branches/:branch
 */
public class PerforceGetBranchRoute implements
        Route,
        P4Methods,
        ModelConversion,
        ResultMapMethods,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String branch = request.params("branch");

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> results = exec(serverHandle, "branch", "-o", branch);

            ResultMap resultMap = firstResultOrFail(results);

            return toBranchCommand(resultMap, offsetSupplier(serverHandle));
        });
    }
}
