package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ResultMap;
import com.perforce.hws.p4base.ResultMapMethods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UserRoute;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import static spark.Spark.halt;

/**
 * GET /p4/:api/users/:user
 */
public class PerforceGetUserRoute implements
        Route,
        P4Methods,
        UserRoute,
        ModelConversion,
        ResultMapMethods,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String user = request.params("user");

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> results = exec(serverHandle, "user", "-o", user);

            if (results.stream().anyMatch(this::isInvalidUserEmail)) {
                halt(404);
            }

            ResultMap resultMap = firstResultOrFail(results);

            Supplier<String> offsetSupplier = offsetSupplier(serverHandle);

            return toUserCommand(resultMap, offsetSupplier);
        });
    }
}
