package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ResultMap;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import static java.util.Collections.addAll;

/**
 * GET /p4/:api/changes
 */
public class PerforceListChangesRoute implements
        Route,
        P4Methods,
        ModelConversion,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String max = request.queryParams("max");
        String status = request.queryParams("status");
        String user = request.queryParams("user");
        String files = request.queryParams("files");

        List<String> args = new ArrayList<>();
        if (max != null) {
            addAll(args, "-m", max);
        }
        if (status != null) {
            addAll(args, "-s", status);
        }
        if (user != null) {
            addAll(args, "-u", user);
        }
        if (files != null) {
            args.add(files);
        }

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> resultMapList = exec(serverHandle, "changes", args.toArray(new String[0]));

            Supplier<String> offsetSupplier = offsetSupplier(serverHandle);

            return resultMapList.stream().map(m -> toChangesCommand(m, offsetSupplier))
                    .collect(Collectors.toList());
        });
    }
}
