package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.stream.Collectors;

/**
 * GET /p4/:api/counters
 */
public class PerforceListCountersRoute implements
        Route,
        P4Methods,
        ModelConversion,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {

        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        return withServerHandle(server, sessionData, settings,
                serverHandle -> exec(serverHandle, "counters").stream()
                        .map(this::toCounter)
                        .collect(Collectors.toList()));
    }
}
