package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.ListingMethods;
import com.perforce.hws.p4base.ResultMap;
import com.perforce.hws.p4base.ResultMapMethods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.function.Supplier;

import static java.util.stream.Collectors.toList;

/**
 * GET /{server}/paths
 */
public class PerforceListPathsRoute implements
        Route,
        ResultMapMethods,
        ModelConversion,
        ListingMethods,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {

        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            // This route isn't using splats at the moment due to restrictions by
            // the OpenAPI specification that we use to generate client SDKs.
            String path = null;
            if (request.queryParams("path") != null) {
                path = request.queryParams("path");
            }

            List<ResultMap> results = listPath(serverHandle, path);

            Supplier<String> offsetSupplier = offsetSupplier(serverHandle);

            return results.stream()
                    .map(m -> toLocation(m, offsetSupplier))
                    .collect(toList());
        });
    }

}
