package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ResultMap;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.sessions.SessionData;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * GET /{server}/users
 */
public class PerforceListUsersRoute implements
        Route,
        P4Methods,
        ModelConversion,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");

        String includeService = request.queryParams("includeService");
        String max = request.queryParams("max");

        List<String> args = new ArrayList<>();
        if (includeService != null && Boolean.valueOf(includeService)) {
            args.add("-a");
        }
        if (max != null) {
            args.add("-m");
            args.add(max);
        }

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> resultMapList = exec(serverHandle, "users", args.toArray(new String[0]));

            Supplier<String> offsetSupplier = offsetSupplier(serverHandle);

            return resultMapList.stream().map(r -> toUsersCommand(r, offsetSupplier))
                    .collect(Collectors.toList());
        });
    }
}
