package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.ProvidesLoginRoute;
import com.perforce.hwsclient.models.LoginRequest;
import com.perforce.hwsclient.models.LoginResponse;
import com.perforce.p4java.impl.mapbased.server.Server;
import spark.Request;
import spark.Response;
import spark.Route;

import static spark.Spark.halt;

/**
 * Provides a means for logging in to a p4d instance.
 */
public class PerforceLoginRoute implements Route, ProvidesLoginRoute, UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        HWSSettings settings = request.attribute("settings");

        String serverId = request.params("server");

        LoginRequest loginRequest = gson.fromJson(request.body(), LoginRequest.class);

        LoginResponse loginResponse = new LoginResponse();

        try (ServerHandle serverHandle = obtainServerHandle(serverId, settings)) {
            if (serverHandle == null) {
                halt(403, "No server");
            }
            String p4ticket = logIn(serverHandle, loginRequest.getUser(), loginRequest.getPassword(), true);
            loginResponse.setTicket(p4ticket);
        }

        return handleLoginResponse(loginResponse, request, response);
    }
}
