package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.BranchCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.Map;

/**
 * PATCH /{server}/branches/{branch}
 */
public class PerforceUpdateBranchRoute implements
        Route,
        P4Methods,
        ResultMapMethods,
        HasGson,
        ModelConversion,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String branch = request.params("branch");

        BranchCommand branchCommand = readModel(request, BranchCommand.class);

        Map<String, Object> updates = toRequestMap(branchCommand);

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            List<ResultMap> results = exec(serverHandle, "branch", "-o", branch);
            Map<String, Object> current = collateArrayEntries(results.get(0));

            current.putAll(updates);

            Map<String, Object> toUpdate = divideArrayEntries(current);

            results = execInput(serverHandle, toUpdate, "branch", "-i");

            return toCommandResponse(results);
        });
    }
}
