package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.ClientCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.Map;

/**
 * PATCH /{server}/clients/{client}
 */
public class PerforceUpdateClientRoute implements
        Route,
        P4Methods,
        ResultMapMethods,
        HasGson,
        ModelConversion,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String branch = request.params("client");

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            ClientCommand clientCommand = readModel(request, ClientCommand.class);

            Map<String, Object> updates = toRequestMap(clientCommand);

            List<ResultMap> results = exec(serverHandle, "client", "-o", branch);
            Map<String, Object> current = collateArrayEntries(results.get(0));

            current.putAll(updates);

            Map<String, Object> toUpdate = divideArrayEntries(current);

            return toCommandResponse(execInput(serverHandle, toUpdate, "client", "-i"));
        });
    }
}
