package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.HasGson;
import com.perforce.hws.p4base.P4Methods;
import com.perforce.hws.p4base.ServerHandle;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.Counter;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.Map;

/**
 * PUT /{server}/counters/{counter}
 */
public class PerforceUpdateCounterRoute implements
        Route,
        P4Methods,
        HasGson,
        ModelConversion,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String counter = request.params("counter");

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            Counter counterModel = readModel(request, Counter.class);

            return toCommandResponse(exec(serverHandle,
                    "counter", "-f", counter, counterModel.getValue()));
        });
    }
}
