package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.DepotCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.Map;

/**
 * PATCH /p4/:api/branches/:branch
 */
public class PerforceUpdateDepotRoute implements
        Route,
        P4Methods,
        ResultMapMethods,
        HasGson,
        ModelConversion,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String depot = request.params("depot");

        DepotCommand depotCommand = readModel(request, DepotCommand.class);

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            Map<String, Object> updates = toRequestMap(depotCommand);

            List<ResultMap> results = exec(serverHandle, "depot", "-o", depot);
            ResultMap resultMap = firstResultOrFail(results);

            Map<String, Object> current = toRequestMap(toDepotCommand(resultMap));

            current.putAll(updates);

            return toCommandResponse(execInput(serverHandle, current, "depot", "-i"));
        });
    }
}
