package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.GroupCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

import static java.util.stream.Collectors.joining;

/**
 * PATCH /p4/:api/groups/:group
 */
public class PerforceUpdateGroupRoute implements
        Route,
        P4Methods,
        ResultMapMethods,
        HasGson,
        GroupSpecMethods,
        ModelConversion,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String group = request.params("group");

        GroupCommand groupCommand = readModel(request, GroupCommand.class);

        return withServerHandle(server, sessionData, settings, serverHandle -> {
            Map<String, Object> updates = toRequestMap(groupCommand);

            List<ResultMap> results = exec(serverHandle, "group", "-o", group);
            ResultMap resultMap = firstResultOrFail(results);
            GroupCommand saved = toGroupCommand(resultMap);
            Map<String, Object> savedMap = toRequestMap(saved);

            savedMap.putAll(updates);

            GroupCommand savedGroup = toGroupCommand(savedMap);

            String groupSpec = toGroupSpec(savedGroup);

            return toCommandResponse(execInputString(serverHandle, groupSpec, "group", "-i"));
        });
    }


}

