package com.perforce.hws.server.routes.perforce;

import com.perforce.hws.p4base.*;
import com.perforce.hws.server.HWSSettings;
import com.perforce.hws.server.ModelConversion;
import com.perforce.hws.server.UsesServerHandles;
import com.perforce.hws.server.routes.UsesJsonRequests;
import com.perforce.hws.server.sessions.SessionData;
import com.perforce.hwsclient.models.JobCommand;

import spark.Request;
import spark.Response;
import spark.Route;

import java.util.List;
import java.util.Map;

/**
 * PATCH /{server}/jobs/{job}
 */
public class PerforceUpdateJobRoute implements
        Route,
        ModelConversion,
        P4Methods,
        ResultMapMethods,
        HasGson,
        UsesJsonRequests,
        UsesServerHandles {

    @Override
    public Object handle(Request request, Response response) throws Exception {
        SessionData sessionData = request.attribute("sessionData");
        HWSSettings settings = request.attribute("settings");

        String server = request.params("server");
        String job = request.params("job");

        JobCommand jobCommand = readModel(request, JobCommand.class);
        Map<String, Object> updates = toRequestMap(jobCommand);

        return withServerHandle(server, sessionData, settings, serverHandle -> {

            List<ResultMap> results = exec(serverHandle, "job", "-o", job);
            ResultMap resultMap = firstResultOrFail(results);
            Map<String, Object> saved = toRequestMap(toJobCommand(resultMap));

            saved.putAll(updates);

            // P4Java adds keys that sometimes are illegal... on some commands.
            if (saved.containsKey("specFormatted")) {
                saved.remove("specFormatted");
            }

            return toCommandResponse(execInput(serverHandle, saved, "job", "-i"));
        });
    }
}

